@extends('admin.layouts.app')

@section('content')
<div class="container">
    <style>
        .tb-col{
            padding: 10px
        }
        .tb-col span{
            font-weight: 600;
            padding: 0px 10px;
        }
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        span.btn.btn-info.game_code_span.float-end{
            color: #666;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .range-btn{
            display: flex;
        }
        .range-btn button{
            margin-left: 10px
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
  <div class="card mt-4">
    <div class="card-header d-flex w-100 justify-content-between align-items-center">
        <h4 class="mb-0">ADD NEW GAME</h4>
      <a class="btn btn-primary btn-main float-end" href="{{ route('admin.game-details.index') }}"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      
    </div>
    <div class="card-body">
      <form action="{{ route('admin.game-details.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        
        <div class="row">
            <div class="col-md-12 mb-3">
                <span class="btn btn-info game_code_span float-end">{{ $gameCode }}</span>
                <div class="form-group">
                {{-- <label for="gameCode">Game Code</label> --}}
                <input type="hidden" class="form-control" id="gameCode" name="game_code" value="{{ $gameCode }}" readonly>
                @if ($errors->has('game_code'))<span class="text-danger">{{ $errors->first('game_code') }}</span>@endif
                </div>
            </div>
            <div class="col-md-12 mb-3">
                <div class="form-group">
                <label for="gameTitle">Game Title<span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="gameTitle" name="game_title" placeholder="Enter game title" value="{{ old('game_title') }}">
                @if ($errors->has('game_title'))<span class="text-danger">{{ $errors->first('game_title') }}</span>@endif
                </div>
            </div>
            <div class="col-md-12 mb-3">
                <div class="form-group">
                <label for="gameDescription">Description<span class="text-danger">*</span></label>
                <textarea rows="3" class="form-control" id="gameDescription" name="game_description" placeholder="Enter game description">{{ old('game_description') }}</textarea>
                @if ($errors->has('game_description'))<span class="text-danger">{{ $errors->first('game_description') }}</span>@endif
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
              <label for="gameCategory">Category<span class="text-danger">*</span></label>
              <select class="form-control w-100" id="gameCategory" name="game_category" {{ old('game_category') }}>
                  @if ($categoryList->isEmpty())
                      <option value="" style="color: red;">
                          No categories found
                      </option>
                  @else
                  <option value="">Select game category</option>
                  @endif
                      @foreach ($categoryList as $category)
                          <option value="{{ $category->id }}">{{ $category->category_name }}</option>
                      @endforeach
              </select>
              @if ($errors->has('game_category'))
                  <span class="text-danger">{{ $errors->first('game_category') }}</span>
              @endif
          </div>  
            </div>
            <div class="col-md-6 mb-3">
          <div class="form-group">
            <label for="gameStartDate">Start Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameStartDate" name="game_start_date" min="{{ date('Y-m-d') }}" {{ old('game_start_date') }}>
            @if ($errors->has('game_start_date'))<span class="text-danger">{{ $errors->first('game_start_date') }}</span>@endif
          </div>
          
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group ">
            <label for="gameEndDate">End Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameEndDate" name="game_end_date" min="{{ date('Y-m-d') }}">
            @if ($errors->has('game_end_date'))<span class="text-danger">{{ $errors->first('game_end_date') }}</span>@endif
          </div>
            </div>
            <div class="col-md-6 mb-3">
          <div class="form-group">
            <label for="gameStartTime">Start Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameStartTime" name="game_start_time" min="{{ date('H:i') }}">
            @if ($errors->has('game_start_time'))<span class="text-danger">{{ $errors->first('game_start_time') }}</span>@endif
          </div>
          
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameEndTime">End Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameEndTime" name="game_end_time" min="{{ date('H:i') }}">
            @if ($errors->has('game_end_time'))<span class="text-danger">{{ $errors->first('game_end_time') }}</span>@endif
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameDrawDate">Draw Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" min="{{ date('Y-m-d') }}">
            @if ($errors->has('game_draw_date'))<span class="text-danger">{{ $errors->first('game_draw_date') }}</span>@endif
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameDrawDate">Draw Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" min="{{ date('Y-m-d') }}">
            @if ($errors->has('game_draw_date'))<span class="text-danger">{{ $errors->first('game_draw_date') }}</span>@endif
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameDrawTime">Draw Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameDrawTime" name="game_draw_time">
            @if ($errors->has('game_draw_time'))<span class="text-danger">{{ $errors->first('game_draw_time') }}</span>@endif
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTimeZone">Time Zone<span class="text-danger">*</span></label>
          <select class="form-control" id="gameTimeZone" name="game_time_zone">
            <option value="">Select Time Zone</option>
            <option value="ist">IST</option>
            <option value="gmt">GMT</option>
            <option value="uae">UAE</option>
          </select>
          @if ($errors->has('game_time_zone'))<span class="text-danger">{{ $errors->first('game_time_zone') }}</span>@endif
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTotalAllowedTicket">Total No's Allowed in a Ticket<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTotalAllowedTicket" name="game_total_allowed_ticket" placeholder="Enter total allowed tickets" value="{{ old('game_total_allowed_ticket') }}">
          @if ($errors->has('game_total_allowed_ticket'))<span class="text-danger">{{ $errors->first('game_total_allowed_ticket') }}</span>@endif
        </div>
        <div class="form-row min-max-range">
            <div class="tb-row d-flex align-items-center">
                <div class="tb-col">
                    <span>1</span>
                </div>
                <div class="tb-col">
                    <input type="number" class="form-control" id="gameMinRange" name="game_min_range" placeholder="Enter Min Range" min="1" value="{{ old('game_min_range') }}">
                </div>
                <div class="tb-col">
                    <input type="number" class="form-control" id="gameMaxRange" name="game_max_range" placeholder="Enter Max Range" max="99" value="{{ old('game_max_range') }}">
                </div>
                <div class="tb-col range-btn">
                    {{-- <button role="button" class="btn btn-success range-add">
                        <i class="fa fa-plus" aria-hidden="true"></i>
                    </button> --}}
                    <button role="button" class="btn btn-danger range-close">
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </button>
                </div>
            </div>

            <div class="tb-row d-flex align-items-center">
                <div class="tb-col">
                    <span>2</span>
                </div>
                <div class="tb-col">
                    <input type="number" class="form-control" id="gameMinRange" name="game_min_range" placeholder="Enter min range start from 1" min="1" value="{{ old('game_min_range') }}">
                </div>
                <div class="tb-col">
                    <input type="number" class="form-control" id="gameMaxRange" name="game_max_range" placeholder="Enter max range till 99" max="99" value="{{ old('game_max_range') }}">
                </div>
                <div class="tb-col range-btn">
                    {{-- <button role="button" class="btn btn-success range-add">
                        <i class="fa fa-plus" aria-hidden="true"></i>
                    </button> --}}
                    <button role="button" class="btn btn-danger range-close">
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </button>
                </div>
            </div>
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTicketPrize">Price of the Ticket(in $)<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTicketPrize" name="game_ticket_prize" placeholder="Enter ticket prize">
          @if ($errors->has('game_ticket_prize'))<span class="text-danger">{{ $errors->first('game_ticket_prize') }}</span>@endif
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameStatus">Game Status<span class="text-danger">*</span></label>
          <select class="form-control" id="gameStatus" name="game_status">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
            <option value="2">Closed</option>
          </select>
          @if ($errors->has('game_status'))<span class="text-danger">{{ $errors->first('game_status') }}</span>@endif
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="featured_image">Featured Image<span class="text-danger">*</span></label>
          <input type="file" class="form-control" name="featured_image" id="featured_image">
          @if ($errors->has('featured_image'))<span class="text-danger">{{ $errors->first('featured_image') }}</span>@endif
          <!-- Image preview container -->
        <div id="image_preview_container" class="mt-3"></div>
        </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
          <button type="submit" class="btn btn-primary btn-main float-end">Save Game</button> 
        </div>
            </div>
        </div>
      </form>
    </div>
  </div>
</div>
@push('scripts')
<script>

$('#gameStartDate').change(function(){
  $('#gameEndDate').prop('min', $(this).val());
  $('#gameEndDate').val('');
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

$('#gameEndDate').change(function(){
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

  $(document).ready(function() {
    // When a file is selected, show the preview
    $("#featured_image").change(function(){
      // Clear the previous preview
      $("#image_preview_container").html("");

      // Get the selected file
      var file = this.files[0];

      // Check if the file is an image
      if (file && file.type.match(/^image\//)) {
        var reader = new FileReader();

        reader.onload = function(e) {
          // Create an image element and set the source to the selected file
          var img = $("<img>").attr("src", e.target.result).addClass("img-thumbnail").height(200).width(200);
          
          // Append the image to the preview container
          $("#image_preview_container").append(img);
        }

        // Read the file as a URL
        reader.readAsDataURL(file);
      }
    });
  });

</script>
@endpush
@endsection
